--[[
The [redacted] Season 2 group select
Written by Rhythm Lunatic

How to put this in your theme:
1. Do not attempt. This is not for beginners. It is very compilicated.
2. StepAMW only! Needs source code edits!
3. Copy this file, add item_scroller.lua to Scripts. (The one from [redacted], not the regular one. The *** one has run_anonymous_function)
4. The favorites folder feature is optional, but if you want it to function make sure you add Scripts/FavoriteManager.lua to your theme and read the instructions.
4. Activate it by broadcasting "StartSelectingGroup" or defining GroupSelectButton1, GroupSelectButton2, GroupSelectPad1, GroupSelectPad2 in CodeNames.
]]
local musicwheel; --To get folders, to open folders... I'm sure you know why this handle is needed.

--==========================
--Special folders... lua doesn't have enums so this is as close as it gets.
--==========================
local WHEELTYPE_NORMAL = 0    --Normal
local WHEELTYPE_USBSONGS = 1  --Use User Custom Steps banner. No difference otherwise.
local WHEELTYPE_PREFERRED = 2 --This is a preferred sort, we need to switch sorts and open the folder
local WHEELTYPE_SORTORDER = 3 --This one switches the sort order
local WHEELTYPE_FROMSORT = 4  --This folder was generated by a sort order, so we display custom graphics

--Optimization. Set to the string of the current sort when sort is changed.
local curSort;
if GAMESTATE:GetSortOrder() then
	curSort = ToEnumShortString(GAMESTATE:GetSortOrder())
else
	curSort = "Group";
end;

--==========================
--Item Scroller. Must be defined at the top to have 'scroller' var accessible to the rest of the lua.
--==========================
local scroller = setmetatable({disable_wrapping= false}, item_scroller_mt)
local numWheelItems = 15

-- Scroller function thingy
local item_mt= {
  __index= {
	-- create_actors must return an actor.  The name field is a convenience.
	create_actors= function(self, params)
	  self.name= params.name
		return Def.ActorFrame{		
			InitCommand= function(subself)
				-- Setting self.container to point to the actor gives a convenient
				-- handle for manipulating the actor.
		  		self.container= subself
		  		subself:SetDrawByZPosition(true);
		  		--subself:zoom(.75);
			end;
				

			
			Def.Sprite{
				Name="banner";
				--InitCommand=cmd(scaletofit,0,0,1,1;);
			};
			--[[Def.BitmapText{
				Name= "text",
				Text="HELLO WORLD!!!!!!!!!";
				Font= "Common Normal",
				InitCommand=cmd(addy,100;DiffuseAndStroke,Color("White"),Color("Black");shadowlength,1);
			};]]
		};
	end,
	-- item_index is the index in the list, ranging from 1 to num_items.
	-- is_focus is only useful if the disable_wrapping flag in the scroller is
	-- set to false.
	transform= function(self, item_index, num_items, is_focus)
		local offsetFromCenter = item_index-math.floor(numWheelItems/2)
		--PrimeWheel(self.container,offsetFromCenter,item_index,numWheelItems)
		--self.container:hurrytweening(2);
		--self.container:finishtweening();
		self.container:stoptweening();
		if math.abs(offsetFromCenter) < 4 then
			self.container:decelerate(.45);
			self.container:visible(true);
		else
			self.container:visible(false);
		end;
		self.container:x(offsetFromCenter*350)
		--self.container:rotationy(offsetFromCenter*-45);
		self.container:zoom(math.cos(offsetFromCenter*math.pi/3)*.9):diffusealpha(math.cos(offsetFromCenter*math.pi/3)*.9);
		
		--[[if offsetFromCenter == 0 then
			self.container:diffuse(Color("Red"));
		else
			self.container:diffuse(Color("White"));
		end;]]
	end,
	-- info is one entry in the info set that is passed to the scroller.
	set= function(self, info)
		--self.container:GetChild("text"):settext(info);
		assert(info[2] ~= "")
		local banner;
		if info[1] == WHEELTYPE_SORTORDER then
			banner = THEME:GetPathG("Banner",info[3]);
		elseif info[1] == WHEELTYPE_USBSONGS then
			banner = THEME:GetPathG("Banner","UCS");
		elseif info[1] == WHEELTYPE_PREFERRED then
			--Maybe it would be better to use info[3] and a graphic named CoopSongs.txt.png? I'm not sure.
			banner = THEME:GetPathG("Banner",info[2]);
		elseif info[1] == WHEELTYPE_FROMSORT then
			if curSort == "DoubleAllDifficultyMeter" or curSort == "AllDifficultyMeter" then
				if tonumber(info[2]) < 24 then
					banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/"..info[2]);
				else
					banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/24");
				end;
			elseif curSort == "BPM" then
				local a = string.gsub(info[2],"-%d+","")
				if tonumber(a) < 500 then
					banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/"..info[2]);
				else
					banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/500.png");
				end;
				--self.container:GetChild("text"):settext(string.gsub(info[2],"-%d+",""))
			elseif curSort == "Origin" then
				local num = tonumber(info[2])
				if num and num >=1990 and num <= 2020 then
					banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/"..info[2]);
				else
					banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/unknown.png");
				end;
			else
				banner = THEME:GetPathG("SortOrder","Banners/"..curSort.."/"..info[2]..".png");
				--banner = "";
			end;
		else
			banner = SONGMAN:GetSongGroupBannerPath(info[2]);
		end;
		if banner == "" then
			self.container:GetChild("banner"):Load(THEME:GetPathG("common","fallback group"));
  		else
  			self.container:GetChild("banner"):Load(banner);
  			--self.container:GetChild("text"):visible(false);
		end;
		self.container:GetChild("banner"):scaletofit(-500,-200,500,200);
	end,
	--[[gettext=function(self)
		--return self.container:GetChild("text"):gettext()
		return self.get_info_at_focus_pos();
	end,]]
}}

--==========================
--Calculate groups and such
--==========================
local hearts = GAMESTATE:GetSmallestNumStagesLeftForAnyHumanPlayer();
groups = {};
local shine_index = 1;
local names = SONGMAN:GetSongGroupNames()

--Why the fuck is this global?
selection = 1;
local spacing = 210;
local numplayers = GAMESTATE:GetHumanPlayers();


--If the sort order is not default this will be overridden when the screen is on
local groups = {};
--SCREENMAN:SystemMessage(GAMESTATE:GetSortOrder())



--[[
"Why does this screen take so fucking long to init?!" -Someone out there.
first index is WHEELTYPE

if WHEELTYPE_SORTORDER:
- second index is name of sort and third index is actual sort.
- second index can be anything, it's just a string and isn't used for anything else.
- Third index is also used for the graphic.
If WHEELTYPE_FROMSORT or WHEELTYPE_NORMAL or WHEELTYPE_USBSONGS:
- second index is group.
- if WHEELTYPE_FROMSORT or WHEELTYPE_USBSONGS, second index is also used for the graphic (pulled from Graphics folder)
- third index is number of songs inside the group.
]]

function insertSpecialFolders()
	
	--Insert these... Somewhere.
	--table.insert(groups, 1, );

	groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_Title"), 	"SortOrder_Title"};
	--SM grading is stupid
	--table.insert(groups, 1, {WHEELTYPE_SORTORDER, "Sort By Top Grades", "SortOrder_TopGrades"});
	groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_Artist"),	"SortOrder_Artist"};
	groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_BPM"),		"SortOrder_BPM"};
	groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_Origin"),	"SortOrder_Origin"};
	
	--I like it close to the end since it's faster to access
	groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_AllDifficultyMeter"),			"SortOrder_AllDifficultyMeter"}
	--This should only show up in single player
	if GAMESTATE:GetNumSidesJoined() == 1 then
		groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_DoubleAllDifficultyMeter"),	"SortOrder_DoubleAllDifficultyMeter"};
	end
end;

function genDefaultGroups()
	groups = {};
	--local numHeartsLeft = GetSmallestNumHeartsLeftForAnyHumanPlayer()
	
	--[[
	So using the index in ipairs is actually a really bad idea because if the full tracks folder is skipped, everything explodes becuase now you have a null indexed object in the table
	Therefore this just uses groups[#groups] even though the index starts at 1 and there's nothing in the table yet
	]]
	for _,group in ipairs(getAvailableGroups()) do
		groups[#groups+1] = {WHEELTYPE_NORMAL,group,#SONGMAN:GetSongsInGroup(group)-1}
	end;
	
	--Only show in multiplayer since there's no need to show it in singleplayer.
	if GAMESTATE:GetNumSidesJoined() > 1 then
		groups[#groups+1] = {WHEELTYPE_PREFERRED, "CO-OP Mode","CoopSongs.txt"}
	end;

	insertSpecialFolders();
	
	for i,pn in ipairs(GAMESTATE:GetEnabledPlayers()) do
		--Check for favorites
		if getenv(pname(pn).."HasAnyFavorites") then
			groups[#groups+1] = {WHEELTYPE_PREFERRED, pname(pn).." Favorites", "Favorites.txt"}
		end;
		
		--Check for USB songs
		--The new profile screen shouldn't allow you to progress with a blank name, but people can edit Editable.ini and set it manually...
		if PROFILEMAN:ProfileWasLoadedFromMemoryCard(pn) and #PROFILEMAN:GetProfile(pn):get_songs() > 0 and PROFILEMAN:GetProfile(pn):GetDisplayName() ~= "" then
			groups[#groups+1] = {WHEELTYPE_USBSONGS, PROFILEMAN:GetProfile(pn):GetDisplayName()}
		end;
	end;
	
	
	if GAMESTATE:GetCurrentSong() then
		local curGroup = GAMESTATE:GetCurrentSong():GetGroupName();
		for key,value in pairs(groups) do
			if curGroup == value[2] then
				selection = key;
			end
		end;
		setenv("cur_group",groups[selection][2]);
	else
		--This can occur when changing sorts since sometimes it will kick you out of the folder (because that song isn't in any of the sort generated folders)
		--Not sure what to do other than ignore it, since it's not a real bug
		--lua.ReportScriptError("The current song should have been set in ScreenSelectPlayMode!");
	end;
end;
function genSortOrderGroups()
	--Trace(Serialize(musicwheel:GetCurrentSections()))
	--Flush();
	--do return end;
	groups = {};
	for i,group in ipairs(musicwheel:GetCurrentSections()) do
		groups[i] = {WHEELTYPE_FROMSORT,group[1],group[2]}
	end;
	groups[#groups+1] = {WHEELTYPE_SORTORDER, THEME:GetString("ScreenSelectGroup","SortOrder_Group"), "SortOrder_Group"};
	insertSpecialFolders();
end;


if (GAMESTATE:GetSortOrder() == nil or GAMESTATE:GetSortOrder() == "SortOrder_Group" or GAMESTATE:GetSortOrder() == "SortOrder_Preferred") then
	genDefaultGroups();
end;


--=======================================================
--Input handler. Brought to you by PIU Delta NEX Rebirth.
--=======================================================
local button_history = {"none", "none", "none", "none"};
local function inputs(event)
	
	local pn= event.PlayerNumber
	local button = event.button
	-- If the PlayerNumber isn't set, the button isn't mapped.  Ignore it.
	--Also we only want it to activate when they're NOT selecting the difficulty.
	if not pn or not SCREENMAN:get_input_redirected(pn) then return end

	-- If it's a release, ignore it.
	if event.type == "InputEventType_Release" then return end
	
	if button == "Center" or button == "Start" then
		if groups[selection][1] == WHEELTYPE_SORTORDER then
			--MESSAGEMAN:Broadcast("SortChanged",{newSort=groups[selection][3]})
			if musicwheel:ChangeSort(groups[selection][3]) then
				curSort = ToEnumShortString(GAMESTATE:GetSortOrder())
				if GAMESTATE:GetSortOrder() == "SortOrder_Group" then
					genDefaultGroups();
				else
					genSortOrderGroups();
				end;
				selection = 1
				--SCREENMAN:SystemMessage("SortChanged")
				scroller:set_info_set(groups, 1);
				setenv("cur_group",groups[selection][2]);
				--scroller:set_info_set({"aaa","bbb","ccc","ddd"},1);
				--Update the text that says the current group.
				MESSAGEMAN:Broadcast("GroupChange");
				--Spin the groups cuz it will look cool.
				--It doesn't work..
				--SCREENMAN:SystemMessage("Test!");
				scroller:run_anonymous_function(function(self, info)
					self.container:stoptweening():linear(.3):rotationy(360):sleep(0):rotationy(0);
				end)
			end;
		else
			SCREENMAN:set_input_redirected(PLAYER_1, false);
			SCREENMAN:set_input_redirected(PLAYER_2, false);
			MESSAGEMAN:Broadcast("StartSelectingSong");
		end;
	elseif button == "DownLeft" or button == "Left" or button == "MenuLeft" then
		SOUND:PlayOnce(THEME:GetPathS("MusicWheel", "change"), true);
		if selection == 1 then
			selection = #groups;
		else
			selection = selection - 1 ;
		end;
		scroller:scroll_by_amount(-1);
		setenv("cur_group",groups[selection][2]);
		MESSAGEMAN:Broadcast("GroupChange");
		
	elseif button == "DownRight" or button == "Right" or button == "MenuRight" then
		SOUND:PlayOnce(THEME:GetPathS("MusicWheel", "change"), true);
		if selection == #groups then
			selection = 1;
		else
			selection = selection + 1
		end
		scroller:scroll_by_amount(1);
		setenv("cur_group",groups[selection][2]);
		MESSAGEMAN:Broadcast("GroupChange");
	--elseif button == "UpLeft" or button == "UpRight" then
		--SCREENMAN:AddNewScreenToTop("ScreenSelectSort");
	
	elseif button == "Back" then
		SCREENMAN:set_input_redirected(PLAYER_1, false);
		SCREENMAN:set_input_redirected(PLAYER_2, false);
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen");
	elseif button == "MenuDown" then
		--[[local curItem = scroller:get_actor_item_at_focus_pos().container:GetChild("banner");
		local scaledHeight = testScaleToWidth(curItem:GetWidth(), curItem:GetHeight(), 500);
		SCREENMAN:SystemMessage(curItem:GetWidth().."x"..curItem:GetHeight().." -> 500x"..scaledHeight);]]
		
		--local curItem = scroller:get_actor_item_at_focus_pos();
		--SCREENMAN:SystemMessage(ListActorChildren(curItem.container));
	else
		--SCREENMAN:SystemMessage(strArrayToString(button_history));
		--musicwheel:SetOpenSection("");
		--SCREENMAN:SystemMessage(musicwheel:GetNumItems());
		--[[local wheelFolders = {};
		for i = 1,7,1 do
			wheelFolders[#wheelFolders+1] = musicwheel:GetWheelItem(i):GetText();
		end;
		SCREENMAN:SystemMessage(strArrayToString(wheelFolders));]]
		--SCREENMAN:SystemMessage(musicwheel:GetWheelItem(0):GetText());
	end;
	
end;

local isPickingDifficulty = false;
local t = Def.ActorFrame{
	
	InitCommand=cmd(diffusealpha,0);
	OnCommand=function(self)
		SCREENMAN:GetTopScreen():AddInputCallback(inputs);
		musicwheel = SCREENMAN:GetTopScreen():GetChild('MusicWheel');
		if (GAMESTATE:GetSortOrder() == nil or GAMESTATE:GetSortOrder() == "SortOrder_Group" or GAMESTATE:GetSortOrder() == "SortOrder_Preferred") then
			scroller:set_info_set(groups, 1);
		else
			genSortOrderGroups();
			local curGroup = musicwheel:GetSelectedSection();
			--SCREENMAN:SystemMessage(curGroup);
			for key,value in pairs(groups) do
				if curGroup == value[2] then
					selection = key;
				end
			end;
			--assert(groups,"REEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE")
			setenv("cur_group",groups[selection][2]);
			scroller:set_info_set(groups, 1);
		end;
		scroller:scroll_by_amount(selection-1)
		--I got sick of input locking when I reloaded the screen
		SCREENMAN:set_input_redirected(PLAYER_1, false);
		SCREENMAN:set_input_redirected(PLAYER_2, false);
	end;

	SongChosenMessageCommand=function(self)
		isPickingDifficulty = true;
	end;
	TwoPartConfirmCanceledMessageCommand=cmd(sleep,.1;queuecommand,"PickingSong");
	SongUnchosenMessageCommand=cmd(sleep,.1;queuecommand,"PickingSong");
	
	PickingSongCommand=function(self)
		isPickingDifficulty = false;
	end;
	
	CodeMessageCommand=function(self,param)
		local codeName = param.Name		-- code name, matches the one in metrics
		--player is not needed
		--local pn = param.PlayerNumber	-- which player entered the code
		if codeName == "GroupSelectPad1" or codeName == "GroupSelectPad2" or codeName == "GroupSelectButton1" or codeName == "GroupSelectButton2" then
			if isPickingDifficulty then return end; --Don't want to open the group select if they're picking the difficulty.
			MESSAGEMAN:Broadcast("StartSelectingGroup");
			--SCREENMAN:SystemMessage("Group select opened.");
			--No need to check if both players are present.
			SCREENMAN:set_input_redirected(PLAYER_1, true);
			SCREENMAN:set_input_redirected(PLAYER_2, true);
			musicwheel:Move(0); --Having the musicwheel move while we're picking a group would be bad, so stop movement.
		else
			--Debugging only
			--SCREENMAN:SystemMessage(codeName);
		end;
	end;
	
	StartSelectingGroupMessageCommand=function(self,params)
		local curItem = scroller:get_actor_item_at_focus_pos();
		--SCREENMAN:SystemMessage(ListActorChildren(curItem.container));
		curItem.container:GetChild("banner"):stoptweening():scaletofit(-500,-200,500,200);
		self:stoptweening():linear(.5):diffusealpha(1);
		SOUND:DimMusic(0.3,65536);
		MESSAGEMAN:Broadcast("GroupChange");
	end;

	StartSelectingSongMessageCommand=function(self)
		self:linear(.3):diffusealpha(0);
		scroller:get_actor_item_at_focus_pos().container:GetChild("banner"):linear(.3):zoom(0);
	end;
}


local lastSort = nil;
function setSort(sort)
	lastSort = sort;
	SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(sort);
end;

-- GENRE SOUNDS
t[#t+1] = Def.Sound{
	File=THEME:GetPathS("","_silent");
	InitCommand=cmd(stop);
	StartSelectingSongMessageCommand=function(self)
		SOUND:DimMusic(1,65536);
		
		--local sel = scroller:get_info_at_focus_pos();
		if groups[selection][1] == WHEELTYPE_PREFERRED then
			setSort("SortOrder_Preferred")
			SONGMAN:SetPreferredSongs(groups[selection][3]);
			self:load(THEME:GetPathS("","Genre/"..groups[selection][2]));
			SCREENMAN:GetTopScreen():GetMusicWheel():SetOpenSection(groups[selection][2]);
		else
			if GAMESTATE:GetSortOrder() == "SortOrder_Preferred" then
				setSort("SortOrder_Group")
				--MESSAGEMAN:Broadcast("StartSelectingSong");
				-- Odd, changing the sort order requires us to call SetOpenSection more than once
				SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(sort);
				--[[SCREENMAN:GetTopScreen():CloseCurrentSection();
				SCREENMAN:GetTopScreen():GetMusicWheel():SetOpenSection("");
				SCREENMAN:GetTopScreen():PostScreenMessage( 'SM_SongChanged', 0.1 );]]
				SCREENMAN:GetTopScreen():GetMusicWheel():SetOpenSection(groups[selection][2]);
				--[[SCREENMAN:GetTopScreen():GetMusicWheel():Move(1)
				SCREENMAN:GetTopScreen():GetMusicWheel():Move(0);
				SCREENMAN:SystemMessage(SCREENMAN:GetTopScreen():GetMusicWheel():GetSelectedSection())
				SCREENMAN:GetTopScreen():GetMusicWheel():SetOpenSection(groups[selection]);
				SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(sort);
				SCREENMAN:GetTopScreen():GetMusicWheel():SetOpenSection(groups[selection]);
				SCREENMAN:GetTopScreen():PostScreenMessage( 'SM_SongChanged', 0.1 );]]
			end;
			SCREENMAN:GetTopScreen():GetMusicWheel():SetOpenSection(groups[selection][2]);
			--SCREENMAN:SystemMessage(groups[selection]);
			--It works... But only if there's a banner.
			local fir = SONGMAN:GetSongGroupBannerPath(getenv("cur_group"));
			if fir then
				self:load(soundext(gisub(fir,'banner.png','info/sound')));
			end;
		end;
		SCREENMAN:GetTopScreen():PostScreenMessage( 'SM_SongChanged', 0.1 );

		--Unreliable, current song doesn't update fast enough.
		--[[if SONGMAN:WasLoadedFromAdditionalSongs(GAMESTATE:GetCurrentSong()) then
			self:load(soundext("/AdditionalSongs/"..getenv("cur_group").."/info/sound"));
		else
			self:load(soundext("/Songs/"..getenv("cur_group").."/info/sound"));
		end]]
		--Make it louder
		self:play();
		self:play();
	end;
};

--THE BACKGROUND VIDEO
--ActorProxies don't work for the BG video unfortunately since they can't be diffused.
--[[t[#t+1] = LoadActor(THEME:GetPathG("","background/common_bg"))..{
	InitCommand=cmd(diffusealpha,0);
	StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,1);
	StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
};]]

t[#t+1] = Def.Quad{
	InitCommand=cmd(Center;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,0;fadetop,1;blend,Blend.Add);
	StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,0.87);
	StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
}
--FLASH
t[#t+1] = Def.Quad{
	InitCommand=cmd(Center;zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,1,1,1,0);
	StartSelectingSongMessageCommand=cmd(stoptweening;diffusealpha,1;linear,0.3;diffusealpha,0);
};

--Add scroller here
t[#t+1] = scroller:create_actors("foo", numWheelItems, item_mt, SCREEN_CENTER_X, SCREEN_CENTER_Y);

	--Current Group/Playlist
t[#t+1] = Def.Sprite{
		Texture=THEME:GetPathB("ScreenSelectMusic","decorations/current_group");
		InitCommand=cmd(x,0;y,5;horizalign,left;vertalign,top;zoomx,1;cropbottom,0.3);
		StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,1;playcommand,"Text");
		StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
	};
	
t[#t+1] = LoadFont("monsterrat/_montserrat light 60px")..{	
		InitCommand=cmd(uppercase,true;horizalign,left;x,SCREEN_LEFT+18;y,SCREEN_TOP+10;zoom,0.185;skewx,-0.1);
		StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,1;playcommand,"GroupChangeMessage");
		StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
		--[[GroupChangeMessageCommand=function(self)
			self:uppercase(true);
			self:settext("Set songlist");
		end;]]
		Text=THEME:GetString("ScreenSelectGroup","SET SONGLIST")
	};
	
t[#t+1] = LoadFont("monsterrat/_montserrat semi bold 60px")..{
		Name="CurrentGroupName";
		InitCommand=cmd(uppercase,true;horizalign,left;x,SCREEN_LEFT+16;y,SCREEN_TOP+30;zoom,0.6;skewx,-0.25);
		StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,1;playcommand,"GroupChangeMessage");
		StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
		GroupChangeMessageCommand=function(self)
			if not getenv("cur_group") then
				self:settext("cur_group env var missing!");
			else
				self:settext(string.gsub(getenv("cur_group"),"^%d%d? ?%- ?", ""));
			end;
		end;
	};
	
--Game Folder counters
--Text BACKGROUND
t[#t+1] = Def.Quad{
	InitCommand=cmd(x,_screen.cx;y,SCREEN_BOTTOM-75;diffuse,{0,0,0,0};zoomto,547,46);
	StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,1;playcommand,"Text");
	StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
};

t[#t+1] = LoadFont("monsterrat/_montserrat light 60px")..{
	InitCommand=cmd(Center;zoom,0.2;y,SCREEN_BOTTOM-75;uppercase,true;strokecolor,0,0.15,0.3,0.5;diffusealpha,0;);
	StartSelectingGroupMessageCommand=cmd(stoptweening;linear,0.35;diffusealpha,1;playcommand,"GroupChangeMessage");
	StartSelectingSongMessageCommand=cmd(stoptweening;linear,0.3;diffusealpha,0);
	GroupChangeMessageCommand=function(self)
		self:finishtweening();
		self:linear(0.3);
		self:diffusealpha(1);
		local songcounter;
		if groups[selection][1] == WHEELTYPE_SORTORDER then
			songcounter = THEME:GetString("ScreenSelectGroup",groups[selection][3])
		elseif groups[selection][1] == WHEELTYPE_NORMAL or groups[selection][1] == WHEELTYPE_FROMSORT then
			--"There are %i songs inside this setlist"
			songcounter = string.format(THEME:GetString("ScreenSelectGroup","SongCount"),groups[selection][3])
		else
			songcounter = THEME:GetString("ScreenSelectGroup","SongCountUnknown")
		end;
		local foldercounter = string.format("%02i",selection).." / "..string.format("%02i",#groups)
		self:settext(songcounter.."\n"..foldercounter);
	end;
};

--t[#t+1] = 	LoadActor("arrow_shine")..{};

--[[
Copyleft (c) Rhythm Lunatic

This is free and unencumbered software released into the public domain.

Anyone is free to copy, modify, publish, use, compile, sell, or
distribute this software, either in source code form or as a compiled
binary, for any purpose, commercial or non-commercial, and by any
means.

In jurisdictions that recognize copyright laws, the author or authors
of this software dedicate any and all copyright interest in the
software to the public domain. We make this dedication for the benefit
of the public at large and to the detriment of our heirs and
successors. We intend this dedication to be an overt act of
relinquishment in perpetuity of all present and future rights to this
software under copyright law.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

For more information, please refer to <http://unlicense.org>
]]


return t;
